/*

                         \\\|///
                       \\  - -  //
                        (  @ @  )
+---------------------oOOo-(_)-oOOo-------------------------+
|                                                           |
|                        PCD5544.c                          |
|                     by Xiaoran Liu                        |
|                        2008.3.16                          |
|                                                           |
|                    ZERO research group                    |
|                        www.the0.net                       |
|                                                           |
|                            Oooo                           |
+----------------------oooO--(   )--------------------------+
                      (   )   ) /
                       \ (   (_/
                        \_)     

*/
// оƬͷļ 
#include <LPC2103.h>
#include "PCD5544.h"

const unsigned char ASC2[]={          
0x00, 0x00, 0x00, 0x00, 0x00,   // sp     
0x00, 0x00, 0x2f, 0x00, 0x00,   // !     
0x00, 0x07, 0x00, 0x07, 0x00,   // "     
0x14, 0x7f, 0x14, 0x7f, 0x14,   // #     
0x24, 0x2a, 0x7f, 0x2a, 0x12,   // $     
0x62, 0x64, 0x08, 0x13, 0x23,   // %     
0x36, 0x49, 0x55, 0x22, 0x50,   // &     
0x00, 0x05, 0x03, 0x00, 0x00,   //      
0x00, 0x1c, 0x22, 0x41, 0x00,   // (     
0x00, 0x41, 0x22, 0x1c, 0x00,   // )     
0x14, 0x08, 0x3E, 0x08, 0x14,   // *     
0x08, 0x08, 0x3E, 0x08, 0x08,   // +     
0x00, 0x00, 0xA0, 0x60, 0x00,   // ,     
0x08, 0x08, 0x08, 0x08, 0x08,   // -     
0x00, 0x60, 0x60, 0x00, 0x00,   // .     
0x20, 0x10, 0x08, 0x04, 0x02,   // /     
0x3E, 0x51, 0x49, 0x45, 0x3E,   // 0     
0x00, 0x42, 0x7F, 0x40, 0x00,   // 1     
0x42, 0x61, 0x51, 0x49, 0x46,   // 2     
0x21, 0x41, 0x45, 0x4B, 0x31,   // 3     
0x18, 0x14, 0x12, 0x7F, 0x10,   // 4     
0x27, 0x45, 0x45, 0x45, 0x39,   // 5     
0x3C, 0x4A, 0x49, 0x49, 0x30,   // 6     
0x01, 0x71, 0x09, 0x05, 0x03,   // 7     
0x36, 0x49, 0x49, 0x49, 0x36,   // 8     
0x06, 0x49, 0x49, 0x29, 0x1E,   // 9     
0x00, 0x36, 0x36, 0x00, 0x00,   // :     
0x00, 0x56, 0x36, 0x00, 0x00,   // ;     
0x08, 0x14, 0x22, 0x41, 0x00,   // <     
0x14, 0x14, 0x14, 0x14, 0x14,   // =     
0x00, 0x41, 0x22, 0x14, 0x08,   // >     
0x02, 0x01, 0x51, 0x09, 0x06,   // ?     
0x32, 0x49, 0x59, 0x51, 0x3E,   // @     
0x7C, 0x12, 0x11, 0x12, 0x7C,   // A     
0x7F, 0x49, 0x49, 0x49, 0x36,   // B     
0x3E, 0x41, 0x41, 0x41, 0x22,   // C     
0x7F, 0x41, 0x41, 0x22, 0x1C,   // D     
0x7F, 0x49, 0x49, 0x49, 0x41,   // E     
0x7F, 0x09, 0x09, 0x09, 0x01,   // F     
0x3E, 0x41, 0x49, 0x49, 0x7A,   // G     
0x7F, 0x08, 0x08, 0x08, 0x7F,   // H     
0x00, 0x41, 0x7F, 0x41, 0x00,   // I     
0x20, 0x40, 0x41, 0x3F, 0x01,   // J     
0x7F, 0x08, 0x14, 0x22, 0x41,   // K     
0x7F, 0x40, 0x40, 0x40, 0x40,   // L     
0x7F, 0x02, 0x0C, 0x02, 0x7F,   // M     
0x7F, 0x04, 0x08, 0x10, 0x7F,   // N     
0x3E, 0x41, 0x41, 0x41, 0x3E,   // O     
0x7F, 0x09, 0x09, 0x09, 0x06,   // P     
0x3E, 0x41, 0x51, 0x21, 0x5E,   // Q     
0x7F, 0x09, 0x19, 0x29, 0x46,   // R     
0x46, 0x49, 0x49, 0x49, 0x31,   // S     
0x01, 0x01, 0x7F, 0x01, 0x01,   // T     
0x3F, 0x40, 0x40, 0x40, 0x3F,   // U     
0x1F, 0x20, 0x40, 0x20, 0x1F,   // V     
0x3F, 0x40, 0x38, 0x40, 0x3F,   // W     
0x63, 0x14, 0x08, 0x14, 0x63,   // X     
0x07, 0x08, 0x70, 0x08, 0x07,   // Y     
0x61, 0x51, 0x49, 0x45, 0x43,   // Z     
0x00, 0x7F, 0x41, 0x41, 0x00,   // [     
0x55, 0x2A, 0x55, 0x2A, 0x55,   // 55     
0x00, 0x41, 0x41, 0x7F, 0x00,   // ]     
0x04, 0x02, 0x01, 0x02, 0x04,   // ^     
0x40, 0x40, 0x40, 0x40, 0x40,   // _     
0x00, 0x01, 0x02, 0x04, 0x00,   //      
0x20, 0x54, 0x54, 0x54, 0x78,   // a     
0x7F, 0x48, 0x44, 0x44, 0x38,   // b     
0x38, 0x44, 0x44, 0x44, 0x20,   // c     
0x38, 0x44, 0x44, 0x48, 0x7F,   // d     
0x38, 0x54, 0x54, 0x54, 0x18,   // e     
0x08, 0x7E, 0x09, 0x01, 0x02,   // f     
0x18, 0xA4, 0xA4, 0xA4, 0x7C,   // g     
0x7F, 0x08, 0x04, 0x04, 0x78,   // h     
0x00, 0x44, 0x7D, 0x40, 0x00,   // i     
0x40, 0x80, 0x84, 0x7D, 0x00,   // j     
0x7F, 0x10, 0x28, 0x44, 0x00,   // k     
0x00, 0x41, 0x7F, 0x40, 0x00,   // l     
0x7C, 0x04, 0x18, 0x04, 0x78,   // m     
0x7C, 0x08, 0x04, 0x04, 0x78,   // n     
0x38, 0x44, 0x44, 0x44, 0x38,   // o     
0xFC, 0x24, 0x24, 0x24, 0x18,   // p     
0x18, 0x24, 0x24, 0x18, 0xFC,   // q     
0x7C, 0x08, 0x04, 0x04, 0x08,   // r     
0x48, 0x54, 0x54, 0x54, 0x20,   // s     
0x04, 0x3F, 0x44, 0x40, 0x20,   // t     
0x3C, 0x40, 0x40, 0x20, 0x7C,   // u     
0x1C, 0x20, 0x40, 0x20, 0x1C,   // v     
0x3C, 0x40, 0x30, 0x40, 0x3C,   // w     
0x44, 0x28, 0x10, 0x28, 0x44,   // x     
0x1C, 0xA0, 0xA0, 0xA0, 0x7C,   // y     
0x44, 0x64, 0x54, 0x4C, 0x44,   // z     
0x00, 0x08, 0x36, 0x41, 0x00,   // {     
0x00, 0x00, 0x7F, 0x00, 0x00,   // |     
0x00, 0x41, 0x36, 0x08, 0x00,   // }     
0x08, 0x10, 0x08, 0x04, 0x08    // ~     
};     

/*----------------------------------------------------------*\
 | Delay                                                    |
\*----------------------------------------------------------*/
void  Delay(unsigned int  dly) {
	unsigned int  i;

	for(; dly>0; dly--) 
		for(i=0; i<5000; i++);
	}
/*----------------------------------------------------------*\
 | PCD5544 SSP Initialize                                       |
\*----------------------------------------------------------*/
void  SSP_Init(void) {
	PCONP |= 1<<10;
    SSPCR0 = (0x01 << 8) |              // SCR  SPIʱӷƵ
             (0x01 << 7) |              // CPHA ʱλ,SPIģʽЧ 
             (0x01 << 6) |              // CPOL ʱ,SPIģʽЧ
             (0x00 << 4) |              // FRF  ֡ʽ 00=SPI,01=SSI,10=Microwire,11=
             (0x07 << 0);               // DSS  ݳ,0000-0010=,0011=4λ,0111=8λ,1111=16λ

    SSPCR1 = (0x00 << 3) |              // SOD  ӻ,1=ֹ,0=
             (0x00 << 2) |              // MS   ѡ,0=,1=ӻ
             (0x01 << 1) |              // SSE  SSPʹ,1=SSP豸ͨ
             (0x00 << 0);               // LBM  дģʽ
             
    SSPCPSR = 0x58;                     // PCLKƵֵ
    SSPIMSC = 0x07;                     // жμĴ
    SSPICR  = 0x03;                     // жĴ
	}
/*----------------------------------------------------------*\
 | PCD5544 Write Byte                                       |
\*----------------------------------------------------------*/
void  LCD_Write(unsigned char byte) {
	//IOCLR=LCD_CS;

	//SSPSR=0;
	SSPDR = byte;
	while( !(SSPSR&0x01) );		// ȴSPIFλȴݷ

	//IOSET=LCD_CS;
	Delay(1);
	}

/*----------------------------------------------------------*\
 | PCD5544 Initialize                                       |
\*----------------------------------------------------------*/
void  LCD_Init(void) {
	//PINSEL0 &= 0xEFFFFFFF;	// SPIܽ
	PINSEL0 |= 0x20000000;	// SPIܽ
	//PINSEL1 &= 0xFFFFFCFF;	// SPIܽ
	PINSEL1 |= 0x00000100;	// SPIܽ

	IODIR |= (1<<21)|(1<<13)|(1<<19);
	IOCLR = (1<<19);

	//SSPCCR = 0x08;		// SPIʱӷƵ
	//SSPCR = 0x38;		// SPIӿģʽMSTR=1CPOL=1CPHA=1LSBF=0
	SSP_Init();

	IOSET=(1<<19);

	IOCLR=(1<<21);
	IOCLR=(1<<13);			//׼дָ     
	/*
	LCD_Write(32+1);	//չָ   
	LCD_Write(128+38);	//Vop,൱       
	LCD_Write(4+3);		//¶ϵ,൱ڶԱȶ       
	LCD_Write(16 +3);	// ƫ,Ҫ벻ҪʵЧһ   
	LCD_Write(32+0);	//ָ    
	LCD_Write(12);		//ʹоƬ/ֱѰַ    
	*/
	LCD_Write(0x21);//ʼLcd,趨ʹָ
	LCD_Write(0xd0);//趨Һƫõѹ
	LCD_Write(0x20);//ʹûָ
	LCD_Write(0x0C);//趨ʾģʽʾ
	IOSET=(1<<21);
	Delay(1);
	}
/*----------------------------------------------------------*\
 | PCD5544 goto x,y                                         |
\*----------------------------------------------------------*/
void  LCD_GotoXY(unsigned char x, unsigned char y) {
	IOCLR = (1<<13);			//׼дָ     
	IOCLR = (1<<21);
	LCD_Write(128+x);
	LCD_Write(64+y);
	IOSET=(1<<21);
	Delay(1);
	}	
/*----------------------------------------------------------*\
 | PCD5544 clear screen                                     |
\*----------------------------------------------------------*/
void  LCD_Cls(void) {
	int i;
	LCD_GotoXY(0,0);
	IOSET = (1<<13);			//׼д
	IOCLR = (1<<21);
	for(i=0;i<504;i++)
		//LCD_Write(0x55);
		LCD_Write(0);
	IOSET=(1<<21);
	Delay(1);
	}	
/*----------------------------------------------------------*\
 | PCD5544 put a character                                  |
\*----------------------------------------------------------*/
void LCD_Putchar(unsigned char character) {		//ʾASCIIֵַ     
	unsigned char i=0;     
	unsigned int No;     
	IOCLR=(1<<21);
	No=character-32;		//ģɿոʼ,ոַASCIIֵ32     
	No=No*5;				//ÿַģ5ֽ     
	IOSET=(1<<13);			//׼д
	while(i<5) {			//һַģ5ֽ,5*8      
		LCD_Write(ASC2[No]);       
		i++;     
		No++;     
		}     
	LCD_Write(0);			//ÿַ֮һ     
	IOSET=(1<<21);
	Delay(1);
	}       
/*----------------------------------------------------------*\
 | PCD5544 print string                                     |
\*----------------------------------------------------------*/
void LCD_PrintStr(unsigned char *s) {		//ʾַ
	while( *s ) {
	     LCD_Putchar( *s++ );
		 }
	}



